/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.workers;

import javax.swing.SwingWorker;
import net.ftb.data.LoginResponse;
import net.ftb.gui.LaunchFrame;
import net.ftb.log.Logger;
import net.ftb.util.ErrorUtils;
import net.ftb.workers.AuthlibHelper;

public class LoginWorker
extends SwingWorker<String, Void> {
    private String username;
    private String password;
    private String mojangData;
    LoginResponse resp;

    public LoginWorker(String username, String password, String mojangData) {
        this.username = username;
        this.password = password;
        this.mojangData = mojangData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doInBackground() {
        try {
            if (!LaunchFrame.canUseAuthlib) {
                ErrorUtils.tossError("Authlib Unavaible");
                return "";
            }
            try {
                LoginResponse resp;
                this.resp = resp = AuthlibHelper.authenticateWithAuthlib(this.username, this.password, this.mojangData);
                if (resp != null && resp.getUsername() != null && !resp.getUsername().isEmpty()) {
                    return "good";
                }
                if (resp == null) {
                    return "nullResponse";
                }
                if (resp.getUsername() == null) {
                    return "NullUsername";
                }
                if (resp.getSessionID() != null) return "bad";
                return "offline";
            }
            catch (Exception e) {
                Logger.logError("Error using authlib", e);
                return "";
            }
        }
        catch (Exception e) {
            ErrorUtils.tossError("Exception occurred, minecraft servers might be down. Check @ help.mojang.com");
        }
        return "";
    }

    public LoginResponse getResp() {
        return this.resp;
    }
}

